#!BPY

"""
Name: 'Relative Object Ipo'
Blender: 248
Group: 'Animation'
Tooltip: 'Move all Object Ipo curves (eg. LocX) to their relative equivalents (eg. dLocX)'
""" 

# -------------------------------------------------------------------------- 
# ***** BEGIN GPL LICENSE BLOCK ***** 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, 
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
# 
# ***** END GPL LICENCE BLOCK ***** 
# -------------------------------------------------------------------------- 
# Changes:
# v1.1: Thanks to 'Gwenouille' for some additions to keep the curve's extend and interpolation mode

__author__ = "Matt Ebb"
__url__ = ("http://wiki.blender.org/index.php/Scripts/Manual/Animation/Relative_Object_IPO")
__version__ = "1.0"


import Blender
from Blender import *

scn = Scene.GetCurrent()

ob = scn.objects.active
ipo = ob.ipo

sources = [Ipo.OB_LOCX, Ipo.OB_LOCY, Ipo.OB_LOCZ, \
Ipo.OB_ROTX, Ipo.OB_ROTY, Ipo.OB_ROTZ, \
Ipo.OB_SCALEX, Ipo.OB_SCALEY, Ipo.OB_SCALEZ]

targets = [Ipo.OB_DLOCX, Ipo.OB_DLOCY, Ipo.OB_DLOCZ, \
Ipo.OB_DROTX, Ipo.OB_DROTY, Ipo.OB_DROTZ, \
Ipo.OB_DSCALEX, Ipo.OB_DSCALEY, Ipo.OB_DSCALEZ]

targetNames = ['dLocX', 'dLocY', 'dLocZ', \
'dRotX', 'dRotY', 'dRotZ', \
'dScaleX', 'dScaleY', 'dScaleZ']

for i in range(len(sources)):
	source = sources[i]
	target = targets[i]
	targetName = targetNames[i]
	
	if ipo[source]:
		if ipo[target]:
			ipo[target] = None
		
		targCurve = ipo.addCurve(targetName)
		targCurve.extend=ipo[source].extend
		targCurve.interpolation=ipo[source].interpolation
		
		for bp in ipo[source].bezierPoints:
			targCurve.append(bp)
	
		ipo[source] = None
	
ob.loc = [ 0.0, 0.0, 0.0]
ob.rot = [ 0.0, 0.0, 0.0]
ob.size = [ 1.0, 1.0, 1.0]
scn.update(1)